VERSION 5.00
Begin VB.Form frmCapitals 
   Appearance      =   0  'Flat
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "US Capitals"
   ClientHeight    =   5190
   ClientLeft      =   1110
   ClientTop       =   1665
   ClientWidth     =   3420
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   8.25
      Charset         =   0
      Weight          =   700
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   ForeColor       =   &H80000008&
   LinkTopic       =   "Form1"
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   5190
   ScaleWidth      =   3420
   Begin VB.CommandButton cmdNext 
      Caption         =   "&Next Question"
      Enabled         =   0   'False
      Height          =   375
      Left            =   240
      TabIndex        =   11
      Top             =   4200
      Width           =   1455
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "E&xit"
      Height          =   375
      Left            =   240
      TabIndex        =   9
      Top             =   4680
      Width           =   1455
   End
   Begin VB.TextBox txtAnswer 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   492
      Left            =   120
      TabIndex        =   7
      Top             =   1800
      Visible         =   0   'False
      Width           =   3132
   End
   Begin VB.Label lblComment 
      Alignment       =   2  'Center
      BackColor       =   &H00C00000&
      BorderStyle     =   1  'Fixed Single
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   -1  'True
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H0000FFFF&
      Height          =   495
      Left            =   1560
      TabIndex        =   10
      Top             =   1200
      Width           =   1695
   End
   Begin VB.Label lblScore 
      Alignment       =   2  'Center
      AutoSize        =   -1  'True
      BackColor       =   &H0000FFFF&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "0%"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   2400
      TabIndex        =   8
      Top             =   4440
      Width           =   645
   End
   Begin VB.Label lblAnswer 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   1  'Fixed Single
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Index           =   3
      Left            =   120
      TabIndex        =   6
      Top             =   3600
      Width           =   3135
   End
   Begin VB.Label lblAnswer 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   1  'Fixed Single
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Index           =   2
      Left            =   120
      TabIndex        =   5
      Top             =   3000
      Width           =   3135
   End
   Begin VB.Label lblAnswer 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   1  'Fixed Single
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Index           =   1
      Left            =   120
      TabIndex        =   4
      Top             =   2400
      Width           =   3135
   End
   Begin VB.Label lblAnswer 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   1  'Fixed Single
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Index           =   0
      Left            =   120
      TabIndex        =   3
      Top             =   1800
      Width           =   3135
   End
   Begin VB.Label lblHeadAnswer 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      Caption         =   "Capital:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H80000008&
      Height          =   495
      Left            =   120
      TabIndex        =   2
      Top             =   1200
      Width           =   1215
   End
   Begin VB.Label lblGiven 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   1  'Fixed Single
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   120
      TabIndex        =   1
      Top             =   600
      Width           =   3135
   End
   Begin VB.Label lblHeadGiven 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      Caption         =   "State:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H80000008&
      Height          =   495
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   1335
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuFileNew 
         Caption         =   "&New"
      End
      Begin VB.Menu mnuFileBar 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFileExit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu mnuOptions 
      Caption         =   "&Options"
      Begin VB.Menu mnuOptionsCapitals 
         Caption         =   "Name &Capitals"
         Checked         =   -1  'True
      End
      Begin VB.Menu mnuOptionsState 
         Caption         =   "Name &State"
      End
      Begin VB.Menu mnuOptionsBar 
         Caption         =   "-"
      End
      Begin VB.Menu mnuOptionsMC 
         Caption         =   "&Multiple Choice Answers"
         Checked         =   -1  'True
      End
      Begin VB.Menu mnuOptionsType 
         Caption         =   "&Type In Answers"
      End
   End
End
Attribute VB_Name = "frmCapitals"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim CorrectAnswer As Integer
Dim NumAns As Integer, NumCorrect As Integer
Dim Wsound(26) As Integer
Dim State(50) As String, Capital(50) As String


Private Function SoundEx(W As String, Wsound() As Integer) As String
'Generates Soundex code for W
'Allows answers whose spelling is close, but not exact
Dim Wtemp As String, S As String
Dim L As Integer, I As Integer
Dim Wprev As Integer, Wsnd As Integer, Cindex As Integer
Wtemp = UCase(W)
L = Len(W)
If L <> 0 Then
  S = Left(Wtemp, 1)
  Wprev = 0
  If L > 1 Then
    For I = 2 To L
      Cindex = Asc(Mid(Wtemp, I, 1)) - 64
      If Cindex >= 1 And Cindex <= 26 Then
        Wsnd = Wsound(Cindex) + 48
        If Wsnd <> 48 And Wsnd <> Wprev Then S = S + Chr(Wsnd)
        Wprev = Wsnd
      End If
    Next I
  End If
Else
  S = ""
End If
SoundEx = S
End Function
Private Sub Update_Score(Iscorrect As Integer)
Dim I As Integer
'Check if answer is correct
cmdNext.Enabled = True
cmdNext.SetFocus
If Iscorrect = 1 Then
  NumCorrect = NumCorrect + 1
  lblComment.Caption = "Correct!"
Else
  lblComment.Caption = "Sorry ..."
End If
'Display correct answer and update score
If mnuOptionsMC.Checked = True Then
  For I = 0 To 3
    If mnuOptionsCapitals.Checked = True Then
      If lblAnswer(I).Caption <> Capital(CorrectAnswer) Then
        lblAnswer(I).Caption = ""
      End If
    Else
      If lblAnswer(I).Caption <> State(CorrectAnswer) Then
        lblAnswer(I).Caption = ""
      End If
    End If
  Next I
Else
  If mnuOptionsCapitals.Checked = True Then
    txtAnswer.Text = Capital(CorrectAnswer)
  Else
    txtAnswer.Text = State(CorrectAnswer)
  End If
End If
lblScore.Caption = Format(NumCorrect / NumAns, "##0%")
End Sub

Private Sub cmdExit_Click()
'Exit program
Call mnuFileExit_Click
End Sub

Private Sub cmdNext_Click()
'Generate the next question
cmdNext.Enabled = False
Call Next_Question(CorrectAnswer)
End Sub

Private Sub Form_Activate()
Call mnufilenew_click
End Sub

Private Sub Form_Load()
Randomize Timer
'Load soundex function array
Wsound(1) = 0: Wsound(2) = 1: Wsound(3) = 2: Wsound(4) = 3
Wsound(5) = 0: Wsound(6) = 1: Wsound(7) = 2: Wsound(8) = 0
Wsound(9) = 0: Wsound(10) = 2: Wsound(11) = 2: Wsound(12) = 4
Wsound(13) = 5: Wsound(14) = 5: Wsound(15) = 0: Wsound(16) = 1
Wsound(17) = 2: Wsound(18) = 6: Wsound(19) = 2: Wsound(20) = 3
Wsound(21) = 0: Wsound(22) = 1: Wsound(23) = 0: Wsound(24) = 2
Wsound(25) = 0: Wsound(26) = 2
'Load state/capital arrays
State(1) = "Alabama": Capital(1) = "Montgomery"
State(2) = "Alaska": Capital(2) = "Juneau"
State(3) = "Arizona": Capital(3) = "Phoenix"
State(4) = "Arkansas": Capital(4) = "Little Rock"
State(5) = "California": Capital(5) = "Sacramento"
State(6) = "Colorado": Capital(6) = "Denver"
State(7) = "Connecticut": Capital(7) = "Hartford"
State(8) = "Delaware": Capital(8) = "Dover"
State(9) = "Florida": Capital(9) = "Tallahassee"
State(10) = "Georgia": Capital(10) = "Atlanta"
State(11) = "Hawaii": Capital(11) = "Honolulu"
State(12) = "Idaho": Capital(12) = "Boise"
State(13) = "Illinois": Capital(13) = "Springfield"
State(14) = "Indiana": Capital(14) = "Indianapolis"
State(15) = "Iowa": Capital(15) = "Des Moines"
State(16) = "Kansas": Capital(16) = "Topeka"
State(17) = "Kentucky": Capital(17) = "Frankfort"
State(18) = "Louisiana": Capital(18) = "Baton Rouge"
State(19) = "Maine": Capital(19) = "Augusta"
State(20) = "Maryland": Capital(20) = "Annapolis"
State(21) = "Massachusetts": Capital(21) = "Boston"
State(22) = "Michigan": Capital(22) = "Lansing"
State(23) = "Minnesota": Capital(23) = "Saint Paul"
State(24) = "Mississippi": Capital(24) = "Jackson"
State(25) = "Missouri": Capital(25) = "Jefferson City"
State(26) = "Montana": Capital(26) = "Helena"
State(27) = "Nebraska": Capital(27) = "Lincoln"
State(28) = "Nevada": Capital(28) = "Carson City"
State(29) = "New Hampshire": Capital(29) = "Concord"
State(30) = "New Jersey": Capital(30) = "Trenton"
State(31) = "New Mexico": Capital(31) = "Santa Fe"
State(32) = "New York": Capital(32) = "Albany"
State(33) = "North Carolina": Capital(33) = "Raleigh"
State(34) = "North Dakota": Capital(34) = "Bismarck"
State(35) = "Ohio": Capital(35) = "Columbus"
State(36) = "Oklahoma": Capital(36) = "Oklahoma City"
State(37) = "Oregon": Capital(37) = "Salem"
State(38) = "Pennsylvania": Capital(38) = "Harrisburg"
State(39) = "Rhode Island": Capital(39) = "Providence"
State(40) = "South Carolina": Capital(40) = "Columbia"
State(41) = "South Dakota": Capital(41) = "Pierre"
State(42) = "Tennessee": Capital(42) = "Nashville"
State(43) = "Texas": Capital(43) = "Austin"
State(44) = "Utah": Capital(44) = "Salt Lake City"
State(45) = "Vermont": Capital(45) = "Montpelier"
State(46) = "Virginia": Capital(46) = "Richmond"
State(47) = "Washington": Capital(47) = "Olympia"
State(48) = "West Virginia": Capital(48) = "Charleston"
State(49) = "Wisconsin": Capital(49) = "Madison"
State(50) = "Wyoming": Capital(50) = "Cheyenne"
End Sub

Private Sub lblAnswer_Click(Index As Integer)
'Check multiple choice answers
Dim Iscorrect As Integer
'If already answered, exit
If cmdNext.Enabled = True Then Exit Sub
Iscorrect = 0
If mnuOptionsCapitals.Checked = True Then
  If lblAnswer(Index).Caption = Capital(CorrectAnswer) Then Iscorrect = 1
Else
  If lblAnswer(Index).Caption = State(CorrectAnswer) Then Iscorrect = 1
End If
Call Update_Score(Iscorrect)
End Sub

Private Sub mnuFileExit_Click()
'End the application
End
End Sub

Private Sub mnufilenew_click()
'Reset the score and start again
NumAns = 0
NumCorrect = 0
lblScore.Caption = "0%"
lblComment.Caption = ""
cmdNext.Enabled = False
Call Next_Question(CorrectAnswer)
End Sub

Private Sub mnuOptionsCapitals_Click()
'Set up for providing capital, given state
mnuOptionsState.Checked = False
mnuOptionsCapitals.Checked = True
lblHeadGiven.Caption = "State:"
lblHeadAnswer.Caption = "Capital:"
Call mnufilenew_click
End Sub

Private Sub mnuOptionsMC_Click()
'Set up for multiple choice answers
Dim I As Integer
mnuOptionsMC.Checked = True
mnuOptionsType.Checked = False
For I = 0 To 3
  lblAnswer(I).Visible = True
Next I
txtAnswer.Visible = False
Call mnufilenew_click
End Sub

Private Sub mnuOptionsState_Click()
'Set up for providing state, given capital
mnuOptionsState.Checked = True
mnuOptionsCapitals.Checked = False
lblHeadGiven.Caption = "Capital:"
lblHeadAnswer.Caption = "State:"
Call mnufilenew_click
End Sub

Private Sub mnuOptionsType_Click()
'Set up for type in answers
Dim I As Integer
mnuOptionsMC.Checked = False
mnuOptionsType.Checked = True
For I = 0 To 3
  lblAnswer(I).Visible = False
Next I
txtAnswer.Visible = True
Call mnufilenew_click
End Sub

Private Sub Next_Question(Answer As Integer)
Dim VUsed(50) As Integer, I As Integer, J As Integer
Dim Index(3)
lblComment.Caption = ""
NumAns = NumAns + 1
'Generate the next question based on selected options
Answer = Int(Rnd * 50) + 1
If mnuOptionsCapitals.Checked = True Then
  lblGiven.Caption = State(Answer)
Else
  lblGiven.Caption = Capital(Answer)
End If
If mnuOptionsMC.Checked = True Then
'Multiple choice answers
'Vused array is used to see which states have
'been selected as possible answers
  For I = 1 To 50
    VUsed(I) = 0
  Next I
'Pick four different state indices (J) at random
'These are used to set up multiple choice answers
'Stored in the Index array
  I = 0
  Do
    Do
      J = Int(Rnd * 50) + 1
    Loop Until VUsed(J) = 0 And J <> CorrectAnswer
    VUsed(J) = 1
    Index(I) = J
    I = I + 1
  Loop Until I = 4
'Now replace one index (at random) with correct answer
  Index(Int(Rnd * 4)) = CorrectAnswer
'Display multiple choice answers in label boxes
  For I = 0 To 3
    If mnuOptionsCapitals.Checked = True Then
      lblAnswer(I).Caption = Capital(Index(I))
    Else
      lblAnswer(I).Caption = State(Index(I))
    End If
  Next I
Else
'Type-in answers
  txtAnswer.Locked = False
  txtAnswer.Text = ""
  txtAnswer.SetFocus
End If
End Sub

Private Sub txtAnswer_KeyPress(KeyAscii As Integer)
'Check type in answer'
Dim Iscorrect As Integer
Dim YourAnswer As String, TheAnswer As String
'Exit if already answered
If cmdNext.Enabled = True Then Exit Sub
If (KeyAscii >= vbKeyA And KeyAscii <= vbKeyZ) _
Or (KeyAscii >= vbKeyA + 32 And KeyAscii <= vbKeyZ + 32) _
Or KeyAscii = vbKeySpace Or KeyAscii = vbKeyBack Or KeyAscii = vbKeyReturn Then
'Acceptable keystroke
  If KeyAscii <> vbKeyReturn Then Exit Sub
'Lock text box once answer entered
  txtAnswer.Locked = True
  Iscorrect = 0
'Convert response and correct answers to all upper
'case for typing problems
  YourAnswer = UCase(txtAnswer.Text)
  If mnuOptionsCapitals.Checked = True Then
    TheAnswer = UCase(Capital(CorrectAnswer))
  Else
    TheAnswer = UCase(State(CorrectAnswer))
  End If
'Check for both exact and approximate spellings
  If YourAnswer = TheAnswer Or _
  SoundEx(YourAnswer, Wsound()) = SoundEx(TheAnswer, Wsound()) Then Iscorrect = 1
  Call Update_Score(Iscorrect)
Else
'Unacceptable keystroke
  KeyAscii = 0
End If
End Sub


